rule Win32_Ransomware_Maktub : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "MAKTUB"
        description         = "Yara rule that detects Maktub ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Maktub"
        tc_detection_factor = 5

    strings:

        $encrypt_files = {
            55 8B EC 83 EC ?? 53 8B 1D ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 8B ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 51 8D B3 ?? ?? ?? ?? 8B CB 56 E8 ?? ?? ?? ?? 85 C0 74 ?? 50 8B 43 ?? FF D0 8D 
            45 ?? C7 45 ?? ?? ?? ?? ?? 50 8B 43 ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 
            B3 ?? ?? ?? ?? FF D0 85 C0 74 ?? 6A ?? 8D 45 ?? C7 45 ?? ?? ?? ?? ?? 50 8B 43 ?? 6A 
            ?? 6A ?? 6A ?? 6A ?? FF 75 ?? C7 45 ?? ?? ?? ?? ?? FF D0 85 C0 75 ?? FF 75 ?? 8B 43 
            ?? FF D0 5E 33 C0 5B 8B E5 5D C3 A1 ?? ?? ?? ?? 57 8B 7D ?? 85 C0 75 ?? FF 15 ?? ?? 
            ?? ?? A3 ?? ?? ?? ?? 57 6A ?? 50 FF 15 ?? ?? ?? ?? 8B 4D ?? 8B F8 89 7D ?? 85 C9 74 
            ?? 8B D1 33 C0 C1 E9 ?? F3 AB 8B CA 83 E1 ?? F3 AA 8B 7D ?? B9 ?? ?? ?? ?? 3B FE 76 
            ?? 8D 46 ?? 3B F8 73 ?? 8D 57 ?? 8D 70 ?? 8B FF 8A 06 8D 52 ?? 88 42 ?? 8D 76 ?? 49 
            75 ?? EB ?? 8B D7 2B D6 8A 06 8D 76 ?? 88 44 32 ?? 49 75 ?? E8 ?? ?? ?? ?? 89 83 ?? 
            ?? ?? ?? 8D 4F ?? 8B 83 ?? ?? ?? ?? 89 47 ?? FF B3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 
            ?? 8D 45 ?? FF 75 ?? 50 8B 43 ?? 57 6A ?? 6A ?? 6A ?? FF 75 ?? FF D0 85 C0 75 ?? A1 
            ?? ?? ?? ?? 85 C0 75 ?? A1 ?? ?? ?? ?? FF D0 A3 ?? ?? ?? ?? 57 6A ?? 50 FF 15 ?? ?? 
            ?? ?? FF 75 ?? 8B 43 ?? FF D0 5F 5E 33 C0 5B 8B E5 5D C3 FF 75 ?? 8D 45 ?? 57 50 E8 
            ?? ?? ?? ?? 50 8D 8B ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? 
            ?? 85 C0 75 ?? A1 ?? ?? ?? ?? FF D0 A3 ?? ?? ?? ?? 57 6A ?? 50 FF 15 ?? ?? ?? ?? FF 
            75 ?? 8B 43 ?? FF D0 5F 5E B8 ?? ?? ?? ?? 5B 8B E5 5D C3 
        }

        $search_files = {
            55 8B EC 83 EC ?? 53 56 57 8B F9 68 ?? ?? ?? ?? FF 75 ?? 8B 47 ?? FF D0 85 C0 0F 84 
            ?? ?? ?? ?? 8B 47 ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? FF 75 ?? 
            FF D0 8B D8 83 FB ?? 0F 84 ?? ?? ?? ?? 8B 4F ?? 8D 45 ?? 50 0F 57 C0 53 66 0F 13 45 
            ?? FF D1 85 C0 0F 84 ?? ?? ?? ?? 8B 75 ?? 8B C6 0B 45 ?? 0F 84 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? FF 15 ?? ?? ?? ?? 8B 55 ?? 8D 45 ?? 6A ?? 50 8D 4D ?? C7 45 ?? ?? ?? ?? ?? FF 
            72 ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 87 ?? ?? ?? ?? 
            8B 55 ?? 8D 4A ?? C7 45 ?? ?? ?? ?? ?? 89 4D ?? FF 70 ?? 50 FF 31 8D 4D ?? E8 ?? ?? 
            ?? ?? 8B 45 ?? 83 C0 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 7F ?? A1 ?? ?? ?? ?? 85 C0 75 ?? 
            FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 75 ?? 6A ?? 50 FF 15 ?? ?? ?? ?? 8B 45 ?? 85 C0 
            7C ?? 7F ?? 81 FE ?? ?? ?? ?? 72 ?? 50 8B 45 ?? 56 53 8B 1D ?? ?? ?? ?? 33 F6 51 8D 
            48 ?? 89 65 ?? 39 31 7C ?? 51 8D 70 ?? FF D3 8B 4D ?? 8D 46 ?? 51 33 F6 89 65 ?? 89 
            01 8B 45 ?? 39 70 ?? 8D 48 ?? 7C ?? 51 8D 70 ?? FF D3 8B 4D ?? 8D 46 ?? 89 01 8B CF 
            E8 ?? ?? ?? ?? 8B 75 ?? 8B F8 E9 ?? ?? ?? ?? 8B 75 ?? 8B 47 ?? 6A ?? 6A ?? 6A ?? 6A 
            ?? 6A ?? 68 ?? ?? ?? ?? 56 FF D0 89 45 ?? 83 F8 ?? 75 ?? 8B 47 ?? 53 FF D0 33 FF E9 
            ?? ?? ?? ?? 51 8D 87 ?? ?? ?? ?? 8B CF 50 E8 ?? ?? ?? ?? 89 45 ?? 85 C0 0F 84 ?? ?? 
            ?? ?? 8B 4D ?? E8 ?? ?? ?? ?? 89 45 ?? 85 C0 0F 84 ?? ?? ?? ?? 6A ?? 8D 4D ?? C7 45 
            ?? ?? ?? ?? ?? 51 FF 75 ?? 50 8B 47 ?? 53 FF D0 85 C0 75 ?? 8B 4D ?? E9 ?? ?? ?? ?? 
            8D 45 ?? C7 45 ?? ?? ?? ?? ?? 50 8D 45 ?? C7 45 ?? ?? ?? ?? ?? 50 8D 45 ?? C7 45 ?? 
            ?? ?? ?? ?? 50 FF 75 ?? FF 75 ?? E8 ?? ?? ?? ?? 8B 4D ?? 85 C0 74 ?? E8 ?? ?? ?? ?? 
            8B 45 ?? 6A ?? 89 45 ?? 8D 45 ?? 50 8B 47 ?? 6A ?? 6A ?? 6A ?? 6A ?? FF 75 ?? FF D0 
            85 C0 75 ?? 8B 4D ?? EB ?? FF 75 ?? 8D 45 ?? 50 FF 75 ?? 8B 47 ?? 6A ?? 6A ?? 6A ?? 
            FF 75 ?? FF D0 85 C0 75 ?? 8B 4D ?? EB ?? 6A ?? 8D 45 ?? C7 45 ?? ?? ?? ?? ?? 50 FF 
            75 ?? 8B 45 ?? 50 FF 75 ?? 8B 47 ?? FF D0 8B 4D ?? 85 C0 74 ?? 8B 45 ?? 3B 45 ?? 74 
            ?? E8 ?? ?? ?? ?? FF 75 ?? 8B 47 ?? FF D0 8B 47 ?? 53 FF D0 FF 75 ?? 8B 47 ?? FF D0 
            8B 47 ?? 56 FF D0 33 FF E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 ?? 8B 47 ?? FF D0 FF 75 
            ?? 8B 47 ?? FF D0 8B 47 ?? 53 FF D0 51 8D 45 ?? 8B CC 50 E8 ?? ?? ?? ?? 8B CF E8 ?? 
            ?? ?? ?? 85 C0 74 ?? 68 ?? ?? ?? ?? 51 8D 45 ?? 8B CC 50 E8 ?? ?? ?? ?? 8B CF E8 ?? 
            ?? ?? ?? 6A ?? 51 8D 45 ?? 8B CC 50 E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? 51 8D 45 ?? 8B CC 50 E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 8D 45 
            ?? 8B CC 50 E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? FF 75 ?? 8B 47 ?? FF D0 85 C0 75 ?? 
            8B 47 ?? 56 FF D0 33 FF EB ?? BF ?? ?? ?? ?? 83 C6 ?? 8D 46 ?? 50 FF 15 ?? ?? ?? ?? 
            85 C0 7F ?? A1 ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B 1D ?? ?? 
            ?? ?? 56 6A ?? 50 FF D3 EB ?? 8B 47 ?? 53 FF D0 33 FF 8B 1D ?? ?? ?? ?? 8B 75 ?? 83 
            C6 ?? 8D 46 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 7F ?? A1 ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? 
            ?? ?? ?? A3 ?? ?? ?? ?? 56 6A ?? 50 FF D3 8B C7 5F 5E 5B 8B E5 5D C2 
        }

        $previous_encrypt_files = {
            0F 84 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 30 FF 77 ?? FF D3 8D 4D 
            ?? 89 87 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 30 FF 
            77 ?? FF D3 8D 4D ?? 89 87 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 4D ?? E8 ?? 
            ?? ?? ?? FF 30 FF 77 ?? FF D3 8B F0 8D 4D ?? 89 B7 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 F6 
            0F 84 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 30 FF 77 ?? FF D3 8B F0 
            8D 4D ?? 89 B7 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 F6 0F 84 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 
            4D ?? E8 ?? ?? ?? ?? FF 30 FF 77 ?? FF D3 8B F0 8D 4D ?? 89 B7 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 85 F6 0F 84 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 30 FF 77 ?? 
            FF D3 8B F0 8D 4D ?? 89 B7 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 F6 0F 84 ?? ?? ?? ?? BA ?? 
            ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 30 FF 77 ?? FF D3 8B F0 8D 4D ?? 89 B7 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 85 F6 0F 84 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 
            30 FF 77 ?? FF D3 8B F0 8D 4D ?? 89 B7 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 F6 0F 84 ?? ?? 
            ?? ?? BA ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 30 FF 77 ?? FF D3 8B F0 8D 4D ?? 89 
            B7 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 F6 0F 84 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 4D ?? E8 ?? 
            ?? ?? ?? FF 30 FF 77 ?? FF D3 8B F0 8D 4D ?? 89 B7 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 F6 
            0F 84 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 30 FF 77 ?? FF D3 8B F0 
            8D 4D ?? 89 B7 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 F6 0F 84 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 
            4D ?? E8 ?? ?? ?? ?? FF 30 FF 15 ?? ?? ?? ?? 8B F0 8D 4D ?? 89 B7 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 85 F6 0F 84 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 30 FF B7 
            ?? ?? ?? ?? FF D3 8B F0 8D 4D ?? 89 B7 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 F6 0F 84 ?? ?? 
            ?? ?? BA ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 30 FF B7 ?? ?? ?? ?? FF D3 8B F0 8D 
            4D ?? 89 B7 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 F6 0F 84 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 4D 
            ?? E8 ?? ?? ?? ?? FF 30 FF 15 ?? ?? ?? ?? 8B F0 8D 4D ?? 89 B7 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 85 F6 0F 84 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 30 FF B7 ?? 
            ?? ?? ?? FF D3 8B F0 8D 4D ?? 89 B7 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 F6 0F 84 ?? ?? ?? 
            ?? BA ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 30 FF B7 ?? ?? ?? ?? FF D3 8B F0 8D 4D 
            ?? 89 B7 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 F6 0F 84 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 4D ?? 
            E8 ?? ?? ?? ?? FF 30 FF B7 ?? ?? ?? ?? FF D3 8B F0 8D 4D ?? 89 B7 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 85 F6 0F 84 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? 6A ?? 8D B7 ?? ?? ?? ?? FF 30 8B 47 ?? 6A ?? 56 FF D0 85 C0 8D 4D ?? 0F 94 C3 E8 
            ?? ?? ?? ?? 84 DB 74 ?? BA ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 
            FF 30 8B 47 ?? 6A ?? 56 FF D0 85 C0 8D 4D ?? 0F 94 C3 E8 ?? ?? ?? ?? 84 DB 0F 85 ?? 
            ?? ?? ?? 5F 5E B8 ?? ?? ?? ?? 5B 8B E5 5D C3 
        }

    condition:
        uint16(0) == 0x5A4D and $search_files and $previous_encrypt_files and $encrypt_files
}